/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import example.JsonDataManagerExample;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import model.Block;
import model.BreadcrumbItem;
import model.Chapter;
import model.Page;
import model.SidebarNavItem;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlToJsonConverter {
    public Page convertHtmlToPage(String htmlFilePath) throws IOException {
        File input = new File(htmlFilePath);
        Document doc = Jsoup.parse(input, "UTF-8", "");
        String pageTitle = doc.title();
        String pageSlug = input.getName().replace(".html", "");
        ArrayList<BreadcrumbItem> breadcrumbs = new ArrayList<BreadcrumbItem>();
        Elements breadcrumbElements = doc.select(".breadcrumb li a");
        for (Element breadcrumbEl : breadcrumbElements) {
            String label = breadcrumbEl.text();
            String url = breadcrumbEl.attr("href");
            breadcrumbs.add(new BreadcrumbItem(label, url));
        }
        ArrayList<SidebarNavItem> sidebarNavItems = new ArrayList<SidebarNavItem>();
        Elements sidebarNavElements = doc.select(".sidebar-nav li a");
        for (Element sidebarNavEl : sidebarNavElements) {
            String label = sidebarNavEl.text();
            String anchor = sidebarNavEl.attr("href");
            boolean isSubItem = sidebarNavEl.parent().hasClass("sub-item") || sidebarNavEl.hasClass("sub-item");
            anchor = anchor != null && anchor.startsWith("#") ? anchor.substring(1) : "";
            sidebarNavItems.add(new SidebarNavItem(label, anchor, isSubItem));
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        Element mainContent = doc.selectFirst(".main-content");
        if (mainContent != null) {
            Elements contentElements = mainContent.children();
            for (Element element : contentElements) {
                String blockType = null;
                HashMap<String, Object> blockData = new HashMap<String, Object>();
                if (element.hasClass("heading-block")) {
                    blockType = "heading-block";
                    Element headingEl = element.selectFirst("h2, h3");
                    if (headingEl != null) {
                        blockData.put("level", Integer.parseInt(headingEl.tagName().replace("h", "")));
                        blockData.put("text", headingEl.text());
                    }
                } else if (element.hasClass("text-block")) {
                    blockType = "text-block";
                    blockData.put("content", element.html());
                } else if (element.hasClass("definition-block")) {
                    Element termEl;
                    Element prefixEl;
                    blockType = "definition-block";
                    iconEl = element.selectFirst(".definition-icon-floated");
                    if (iconEl != null) {
                        blockData.put("iconUrl", iconEl.attr("src"));
                    }
                    if ((prefixEl = element.selectFirst(".definition-header .prefix")) != null) {
                        blockData.put("prefix", prefixEl.text());
                    }
                    if ((termEl = element.selectFirst(".definition-header span[class^=term-]")) != null) {
                        blockData.put("term", termEl.text());
                        for (String className : termEl.classNames()) {
                            if (!className.startsWith("term-")) continue;
                            blockData.put("termColorClass", className);
                            break;
                        }
                    }
                    if ((bodyEl = element.selectFirst(".definition-body")) != null) {
                        blockData.put("definitionContent", ((Element)bodyEl).html());
                    }
                } else if (element.hasClass("code-container")) {
                    Element codeEl;
                    blockType = "code-block";
                    Element headerEl = element.selectFirst(".code-header");
                    if (headerEl != null) {
                        blockData.put("header", headerEl.text());
                    }
                    if ((codeEl = element.selectFirst("pre code")) != null) {
                        bodyEl = codeEl.classNames().iterator();
                        while (bodyEl.hasNext()) {
                            String className = (String)bodyEl.next();
                            if (!className.startsWith("language-")) continue;
                            blockData.put("language", className.replace("language-", ""));
                            break;
                        }
                        blockData.put("code", codeEl.text());
                    }
                } else if (element.hasClass("task-block")) {
                    blockType = "task-block";
                    iconEl = element.selectFirst(".task-icon-floated");
                    if (iconEl != null) {
                        blockData.put("iconUrl", iconEl.attr("src"));
                    }
                    for (String className : element.classNames()) {
                        if (className.equals("task-block") || className.contains("-")) continue;
                        blockData.put("themeClass", className);
                        break;
                    }
                    titleEl = element.selectFirst(".task-header .title");
                    if (titleEl != null) {
                        blockData.put("title", titleEl.text());
                    }
                    ArrayList tasks = new ArrayList();
                    Elements taskItems = element.select(".task-item");
                    for (Element taskItemEl : taskItems) {
                        HashMap<String, Object> taskItemData = new HashMap<String, Object>();
                        Element taskTitleEl = taskItemEl.selectFirst("h4");
                        if (taskTitleEl != null) {
                            taskItemData.put("title", taskTitleEl.text());
                        }
                        Element solutionBox = taskItemEl.selectFirst(".teacher-content.solution-box");
                        String taskContentHtml = taskItemEl.html();
                        if (solutionBox != null) {
                            taskContentHtml = taskContentHtml.replace(solutionBox.outerHtml(), "").trim();
                        }
                        taskItemData.put("taskContent", taskContentHtml);
                        if (solutionBox != null) {
                            Element solutionBody = solutionBox.selectFirst(".solution-body");
                            if (solutionBody != null) {
                                taskItemData.put("solutionContent", solutionBody.html());
                            } else {
                                Element solutionH5 = solutionBox.selectFirst("h5");
                                String solutionHtml = solutionBox.html();
                                if (solutionH5 != null) {
                                    solutionHtml = solutionHtml.replace(solutionH5.outerHtml(), "").trim();
                                }
                                taskItemData.put("solutionContent", solutionHtml);
                            }
                            taskItemData.put("isTeacherContent", true);
                        } else {
                            taskItemData.put("isTeacherContent", false);
                        }
                        tasks.add(taskItemData);
                    }
                    blockData.put("tasks", tasks);
                } else if (element.hasClass("collapsible-task-block")) {
                    blockType = "collapsible-block";
                    iconEl = element.selectFirst(".collapsible-icon-floated");
                    if (iconEl != null) {
                        blockData.put("iconUrl", iconEl.attr("src"));
                    }
                    for (String className : element.classNames()) {
                        if (className.equals("collapsible-task-block") || className.equals("active") || className.contains("-")) continue;
                        blockData.put("themeClass", className);
                        break;
                    }
                    titleEl = element.selectFirst(".collapsible-header .title");
                    if (titleEl != null) {
                        blockData.put("title", titleEl.text());
                    }
                    if ((contentEl = element.selectFirst(".collapsible-content")) != null) {
                        blockData.put("content", ((Element)contentEl).html());
                    }
                    blockData.put("isInitiallyOpen", element.hasClass("active"));
                } else if (element.hasClass("test-block")) {
                    blockType = "test-block";
                    iconEl = element.selectFirst(".test-icon-floated");
                    if (iconEl != null) {
                        blockData.put("iconUrl", iconEl.attr("src"));
                    }
                    contentEl = element.classNames().iterator();
                    while (contentEl.hasNext()) {
                        String className;
                        className = contentEl.next();
                        if (className.equals("test-block") || className.contains("-")) continue;
                        blockData.put("themeClass", className);
                        break;
                    }
                    titleEl = element.selectFirst("h3");
                    if (titleEl != null) {
                        blockData.put("title", titleEl.text());
                    }
                    ArrayList testItems = new ArrayList();
                    Elements testItemElements = element.select(".test-item");
                    for (Element testItemEl : testItemElements) {
                        HashMap<String, String> testItemData = new HashMap<String, String>();
                        Element itemTitleEl = testItemEl.selectFirst("h4");
                        if (itemTitleEl != null) {
                            testItemData.put("title", itemTitleEl.text());
                        }
                        Element solutionToggle = testItemEl.selectFirst(".solution-toggle");
                        String itemContentHtml = testItemEl.html();
                        if (solutionToggle != null) {
                            Element solutionContent = testItemEl.selectFirst(".solution-content");
                            if (solutionContent != null) {
                                itemContentHtml = itemContentHtml.replace(solutionContent.outerHtml(), "").trim();
                            }
                            itemContentHtml = itemContentHtml.replace(solutionToggle.outerHtml(), "").trim();
                        }
                        if (itemTitleEl != null) {
                            itemContentHtml = itemContentHtml.replace(itemTitleEl.outerHtml(), "").trim();
                        }
                        testItemData.put("taskContent", itemContentHtml);
                        Element solutionContentEl = testItemEl.selectFirst(".solution-content");
                        if (solutionContentEl != null) {
                            testItemData.put("solutionContent", solutionContentEl.html());
                        }
                        testItems.add(testItemData);
                    }
                    blockData.put("testItems", testItems);
                } else if (element.hasClass("video-block")) {
                    Element videoContainerEl;
                    blockType = "video-block";
                    iconEl = element.selectFirst(".video-icon-floated");
                    if (iconEl != null) {
                        blockData.put("iconUrl", iconEl.attr("src"));
                    }
                    for (String className : element.classNames()) {
                        if (className.equals("video-block") || className.equals("active") || className.contains("-")) continue;
                        blockData.put("themeClass", className);
                        break;
                    }
                    Element toggleEl = element.selectFirst(".video-block-toggle");
                    if (toggleEl != null) {
                        Element titleEl = toggleEl.selectFirst(".title");
                        if (titleEl != null) {
                            blockData.put("title", titleEl.text());
                        }
                        blockData.put("isInitiallyOpen", element.hasClass("active"));
                    }
                    if ((videoContainerEl = element.selectFirst(".video-container")) != null) {
                        Element sourceEl;
                        Element iframeEl = videoContainerEl.selectFirst("iframe");
                        Element videoEl = videoContainerEl.selectFirst("video");
                        if (iframeEl != null) {
                            blockData.put("videoType", "youtube");
                            blockData.put("videoSource", iframeEl.attr("src"));
                        } else if (videoEl != null && (sourceEl = videoEl.selectFirst("source")) != null) {
                            blockData.put("videoType", "local");
                            blockData.put("videoSource", sourceEl.attr("src"));
                        }
                    }
                    if ((contentEl = element.selectFirst(".video-block-content")) != null) {
                        String contentHtml = ((Element)contentEl).html();
                        Element containerToRemove = ((Element)contentEl).selectFirst(".video-container");
                        if (containerToRemove != null) {
                            contentHtml = contentHtml.replace(containerToRemove.outerHtml(), "").trim();
                        }
                        blockData.put("captionContent", contentHtml);
                    }
                } else if (element.hasClass("text-image-block")) {
                    blockType = "text-image-block";
                    Element imgEl = element.selectFirst("img");
                    if (imgEl != null) {
                        blockData.put("imageUrl", imgEl.attr("src"));
                        blockData.put("imageAlt", imgEl.attr("alt"));
                        blockData.put("imageWidth", imgEl.attr("width"));
                        if (imgEl.hasClass("image-float-left")) {
                            blockData.put("imageFloat", "left");
                        } else if (imgEl.hasClass("image-float-right")) {
                            blockData.put("imageFloat", "right");
                        }
                    }
                    String contentHtml = element.html();
                    if (imgEl != null) {
                        contentHtml = contentHtml.replace(imgEl.outerHtml(), "").trim();
                    }
                    blockData.put("textContent", contentHtml);
                } else if (element.hasClass("image-row-block")) {
                    blockType = "image-row-block";
                    ArrayList<Object> images = new ArrayList<Object>();
                    Elements figures = element.select(".image-row-container figure");
                    contentEl = figures.iterator();
                    while (contentEl.hasNext()) {
                        Element captionEl;
                        Element figureEl = (Element)contentEl.next();
                        HashMap imgData = new HashMap();
                        Element imgEl = figureEl.selectFirst("img");
                        if (imgEl != null) {
                            imgData.put("imageUrl", imgEl.attr("src"));
                            imgData.put("altText", imgEl.attr("alt"));
                        }
                        if ((captionEl = figureEl.selectFirst("figcaption")) != null) {
                            imgData.put("caption", captionEl.html());
                        }
                        images.add(imgData);
                    }
                    blockData.put("images", images);
                } else if (element.hasClass("gallery-block")) {
                    blockType = "gallery-block";
                    Element titleEl = element.selectFirst("h3");
                    if (titleEl != null) {
                        blockData.put("title", titleEl.text());
                    }
                    ArrayList images = new ArrayList();
                    Elements slides = element.select(".gallery-image-slide figure");
                    for (Element figureEl : slides) {
                        Element captionEl;
                        HashMap<String, String> imgData = new HashMap<String, String>();
                        Element imgEl = figureEl.selectFirst("img");
                        if (imgEl != null) {
                            imgData.put("imageUrl", imgEl.attr("src"));
                            imgData.put("altText", imgEl.attr("alt"));
                        }
                        if ((captionEl = figureEl.selectFirst("figcaption")) != null) {
                            imgData.put("caption", captionEl.html());
                        }
                        images.add(imgData);
                    }
                    blockData.put("images", images);
                } else if (element.hasClass("table-block")) {
                    blockType = "table-block";
                    Element tableEl = element.selectFirst("table");
                    if (tableEl != null) {
                        blockData.put("tableHtml", tableEl.outerHtml());
                        blockData.put("isBordered", element.hasClass("bordered"));
                        blockData.put("isShaded", element.hasClass("shaded"));
                        blockData.put("isHeaderHighlighted", element.hasClass("header-highlight"));
                    }
                } else if (element.selectFirst("a img.download-icon") != null && element.tagName().equals("p")) {
                    blockType = "download-link-block";
                    Element linkEl = element.selectFirst("a");
                    if (linkEl != null) {
                        Element iconEl = linkEl.selectFirst("img.download-icon");
                        if (iconEl != null) {
                            blockData.put("iconUrl", iconEl.attr("src"));
                        }
                        blockData.put("linkUrl", linkEl.attr("href"));
                        blockData.put("fileName", linkEl.attr("download"));
                        String pHtml = element.html();
                        String linkHtml = linkEl.outerHtml();
                        String textContent = pHtml.replace(linkHtml, "").trim();
                        blockData.put("linkText", textContent);
                    }
                } else if (element.hasClass("subtopics-container")) {
                    blockType = "subtopics-container";
                    blockData = new HashMap();
                } else if (element.hasClass("teacher-content") && !element.hasClass("solution-box")) {
                    blockType = "teacher-content-block";
                    blockData.put("content", element.html());
                }
                if (blockType != null) {
                    blocks.add(new Block(blockType, blockData));
                    System.out.println("Extrahiert Block-Typ: " + blockType);
                    continue;
                }
                System.out.println("Ignoriere unbekanntes Element oder Nicht-Block-Element: " + element.tagName() + " mit Klassen: " + String.valueOf(element.classNames()));
            }
        }
        Page page = new Page(pageTitle, pageSlug, breadcrumbs, sidebarNavItems, blocks);
        return page;
    }

    public Chapter convertHtmlToChapterWithOnePage(String htmlFilePath) throws IOException {
        Page page = this.convertHtmlToPage(htmlFilePath);
        ArrayList<Page> pages = new ArrayList<Page>();
        pages.add(page);
        String chapterSlug = new File(htmlFilePath).getParentFile().getName();
        String chapterTitle = "Konvertiertes Kapitel (" + chapterSlug + ")";
        return new Chapter(chapterTitle, chapterSlug, "Dieses Kapitel wurde aus HTML konvertiert.", pages);
    }

    private String escapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&").replace("<", "<").replace(">", ">").replace("\"", "").replace("'", "'");
    }

    public static void main(String[] args) {
        HtmlToJsonConverter converter = new HtmlToJsonConverter();
        String filePath = "C:\\Users\\kmast\\OneDrive\\Desktop\\LIfT Webseite mit KI\\Website\\praktische-informatik\\programmierung-mit-greenfoot-seite.html";
        try {
            Page convertedPage = converter.convertHtmlToPage(filePath);
            System.out.println("Konvertierte Seite Titel: " + convertedPage.getPageTitle());
            System.out.println("Anzahl extrahierter Bl\u00f6cke: " + convertedPage.getBlocks().size());
            Chapter convertedChapter = converter.convertHtmlToChapterWithOnePage(filePath);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String jsonOutput = gson.toJson(convertedChapter);
            System.out.println("\nKonvertiertes Chapter als JSON:");
            System.out.println(jsonOutput);
            JsonDataManagerExample.saveChapterToFile(convertedChapter, "data/greenfoot_chapter.json", gson);
        }
        catch (IOException e) {
            System.err.println("Fehler beim Lesen oder Parsen der HTML-Datei: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

